# (c) Copyright 2009-2013. CodeWeavers, Inc.

from gi.repository import Gtk

import bottlequery
import cxlog
import cxutils

import cxmenu

import bottlecollection
import cxguitools

from cxutils import cxgettext as _

class CreateShortcutDialog:

    def __init__(self, bottlename="", command="", name=None, folder=None):
        self.xml = Gtk.Builder()
        self.xml.set_translation_domain("crossover")
        self.xml.add_from_file(cxguitools.get_ui_path("createshortcut"))
        self.xml.connect_signals(self)

        self.local_desktop = cxmenu.local_desktop_path()
        self.local_startmenu = cxmenu.local_start_menu_path()

        self.folder_model = Gtk.TreeStore(str, str, str)
        self.folder_model.set_sort_column_id(2, Gtk.SortType.ASCENDING)

        folder_view = self.xml.get_object("ShortcutFolderTreeView")
        folder_view.set_model(self.folder_model)

        # fill bottle list
        bottlePopupWidget = self.xml.get_object("ShortcutBottlePopup")
        self.bottleListStore = Gtk.ListStore(str)
        bottlePopupWidget.set_model(self.bottleListStore)
        collection = bottlecollection.sharedCollection()
        selectIter = 0
        for bottle in collection.bottle_names():
            newrow = self.bottleListStore.append()
            self.bottleListStore.set_value(newrow, 0, bottle)
            if bottle == bottlename:
                selectIter = newrow

        if selectIter:
            bottlePopupWidget.set_active_iter(selectIter)
        else:
            bottlePopupWidget.set_active_iter(self.bottleListStore.get_iter_first())

        folder_name_renderer = Gtk.CellRendererText()
        folder_name_column = Gtk.TreeViewColumn(_("Folder"), folder_name_renderer)
        folder_name_column.add_attribute(folder_name_renderer, 'text', 0)
        folder_view.append_column(folder_name_column)

        self.xml.get_object("ShortcutCommandEntry").set_text(command)

        if name is None:
            argv = cxutils.cmdlinetoargv(command)
            name = cxutils.basename(argv[0])
            if '.' in name:
                # Remove the extension
                name = name.rsplit('.', 1)[0]

        self.xml.get_object("ShortcutNameEntry").set_text(name)

        if folder is None:
            folder = self.local_startmenu

        self.xml.get_object("ShortcutFolderEntry").set_text(folder)

        self.xml.get_object("ShortcutDialog").show()

    def check_folder_item(self, model, path, path_iter, data):
        if model.get_value(path_iter, 1) == data[0]:
            self.xml.get_object("ShortcutFolderTreeView").set_cursor(path)
            data[1] = True
            return True # stop foreach()
        return False

    def update_folder_selection(self):
        folder = self.xml.get_object("ShortcutFolderEntry").get_text()
        data = [folder, False]
        self.folder_model.foreach(self.check_folder_item, data)
        if data[1] is False:
            self.xml.get_object("ShortcutFolderTreeView").get_selection().unselect_all()

    def populate_folders(self):
        self.folder_model.clear()

        def insert_folder(path, sort_key=None):
            parts = path.split('/')

            pos = None
            child = self.folder_model.get_iter_first()

            for i in range(len(parts)):
                while child is not None:
                    name = self.folder_model.get_value(child, 0)
                    if name == parts[i]:
                        pos = child
                        break
                    child = self.folder_model.iter_next(child)
                else:
                    pos = self.folder_model.insert(pos, 0, (parts[i], '/'.join(parts[0:i+1]), sort_key or parts[i]))
                child = self.folder_model.iter_children(pos)

        insert_folder(self.local_desktop, '0')
        insert_folder(self.local_startmenu, '1')

        bottlename = self.selected_bottle_name()
        properties = bottlequery.get_bottle_properties(bottlename)
        menu = cxmenu.MenuPrefs(bottlename, properties['managed'])
        menu.read_config()

        for path in menu.items:
            if path.startswith('StartMenu'):
                topleveldir = self.local_startmenu
            elif path.startswith('Desktop'):
                topleveldir = self.local_desktop
            else:
                cxlog.warn("Ignoring unrecognized path %s" % cxlog.debug_str(path))
                continue
            basename = path.split('/', 1)[1]
            if '/' in basename:
                dirname, basename = basename.rsplit('/', 1)
                dirname = '%s/%s' % (topleveldir, dirname)
            else:
                dirname = topleveldir

            insert_folder(dirname)

        self.xml.get_object("ShortcutFolderTreeView").expand_all()

        self.update_folder_selection()

    def cancel_clicked(self, caller):
        self.xml.get_object("ShortcutDialog").destroy()
        self.quit_requested(caller)

    def selected_bottle_name(self):
        bottle_popup = self.xml.get_object('ShortcutBottlePopup')
        active_iter = bottle_popup.get_active_iter()
        return self.bottleListStore.get_value(active_iter, 0)

    def ok_clicked(self, _widget):
        bottle = self.selected_bottle_name()
        command = cxutils.string_to_unicode(self.xml.get_object("ShortcutCommandEntry").get_text())
        name = cxutils.string_to_unicode(self.xml.get_object("ShortcutNameEntry").get_text())
        folder = cxutils.string_to_unicode(self.xml.get_object("ShortcutFolderEntry").get_text())

        cxmenu.create_custom_shortcut(bottle, command, name, folder, self.local_desktop, self.local_startmenu)

        self.xml.get_object("ShortcutDialog").destroy()

    def on_entry_changed(self, _widget):
        # We must have a name and command filled in.

        valid = (self.xml.get_object("ShortcutCommandEntry").get_text() and
                 self.xml.get_object("ShortcutNameEntry").get_text())

        self.xml.get_object('ShortcutOk').set_sensitive(bool(valid))

    def folder_cursorchanged(self, treeview):
        cursor_path, _column = treeview.get_cursor()
        if cursor_path is not None:
            cursor_iter = self.folder_model.get_iter(cursor_path)
            folder_text = self.folder_model.get_value(cursor_iter, 1)
            folder_entry = self.xml.get_object("ShortcutFolderEntry")
            if folder_entry.get_text() != folder_text:
                folder_entry.set_text(folder_text)

    def folder_entrychanged(self, _widget):
        self.update_folder_selection()

    def bottle_changed(self, _combo):
        self.populate_folders()

    def quit_requested(self, _caller):
        # pylint: disable=R0201
        cxguitools.toplevel_quit()
